using System;
using System.Collections.Generic;
using System.Linq;

namespace Takmicenje1
{
    internal class Program
    {
        static void Main()
        {
            int N = int.Parse(Console.ReadLine());
            var tacke = new List<(int X, int Y)>();

            for (int i = 0; i < N; i++)
            {
                string[] unos = Console.ReadLine().Split();
                tacke.Add((int.Parse(unos[0]), int.Parse(unos[1])));
            }

            double PovrsinaKonveksnogOmotaca(List<(int X, int Y)> tacke)
            {
                var omotac = new List<(int X, int Y)>();

                tacke = tacke.OrderBy(t => t.X).ThenBy(t => t.Y).ToList();

                foreach (var tacka in tacke)
                {
                    while (omotac.Count >= 2 &&
                           (omotac[omotac.Count - 2].X * (omotac[omotac.Count - 1].Y - tacka.Y) +
                            omotac[omotac.Count - 1].X * (tacka.Y - omotac[omotac.Count - 2].Y) +
                            tacka.X * (omotac[omotac.Count - 2].Y - omotac[omotac.Count - 1].Y)) <= 0)
                    {
                        omotac.RemoveAt(omotac.Count - 1);
                    }
                    omotac.Add(tacka);
                }

                int brojTacakaOmotaca = omotac.Count;
                for (int i = tacke.Count - 2; i >= 0; i--)
                {
                    while (omotac.Count > brojTacakaOmotaca &&
                           (omotac[omotac.Count - 2].X * (omotac[omotac.Count - 1].Y - tacke[i].Y) +
                            omotac[omotac.Count - 1].X * (tacke[i].Y - omotac[omotac.Count - 2].Y) +
                            tacke[i].X * (omotac[omotac.Count - 2].Y - omotac[omotac.Count - 1].Y)) <= 0)
                    {
                        omotac.RemoveAt(omotac.Count - 1);
                    }
                    omotac.Add(tacke[i]);
                }

                double povrsina = 0;
                for (int i = 0; i < omotac.Count; i++)
                {
                    var t1 = omotac[i];
                    var t2 = omotac[(i + 1) % omotac.Count];

                    povrsina += (t1.X * t2.Y) - (t2.X * t1.Y);
                }

                return Math.Abs(povrsina) / 2;
            }

            double ukupnaPovrsina = PovrsinaKonveksnogOmotaca(tacke);
            double minimalnaPovrsina = double.MaxValue;

            for (int i = 0; i < N; i++)
            {
                var tackeBezTacke = tacke.Where((t, index) => index != i).ToList();
                double povrsinaBezTacke = PovrsinaKonveksnogOmotaca(tackeBezTacke);
                minimalnaPovrsina = Math.Min(minimalnaPovrsina, povrsinaBezTacke);
            }

            Console.WriteLine((long)minimalnaPovrsina); // ja stvarno ne znam kako ovo radi, ali donekle je proradilo posle 5h i 4 iskoriscena papira.
        }
    }
}